/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.startgear.Gear;
import dev.toma.gunsrpg.resource.startgear.IGear;
import dev.toma.gunsrpg.util.ModUtils;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class GearAdapter
implements JsonDeserializer<IGear> {
    private static final Marker MARKER = MarkerManager.getMarker((String)"StartGearAdapter");

    public IGear deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected JsonObject to be root element.");
        }
        JsonObject data = json.getAsJsonObject();
        JsonArray elements = JSONUtils.func_151214_t((JsonObject)data, (String)"items");
        ItemStack[] stacks = new ItemStack[elements.size()];
        int i = 0;
        for (JsonElement element : elements) {
            try {
                stacks[i++] = (ItemStack)context.deserialize(element, ItemStack.class);
            }
            catch (JsonParseException exc) {
                GunsRPG.log.error(MARKER, "Error loading start gear item: " + (Object)((Object)exc));
            }
        }
        return new Gear(ModUtils.trimArray(stacks, ItemStack.class));
    }
}

